/*********************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.       *
* Any unauthorized use,  reproduction or transfer of this program is strictly    *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.          *
*********************************************************************************/
`delay_mode_path
`timescale 1ns / 1ns
`ifdef SYNTH
`else
`celldefine
`endif
module csfifo (clr, clock, clockx2, wreq, rreq, data, threshlevel, q, threshold, empty, full);

  parameter lpm_type = "csfifo" ;
  parameter lpm_width  = 1 ;
  parameter lpm_widthad = 1 ;
  parameter lpm_numwords = 2 ;
  parameter polar_data      = "NORMAL" ;
  parameter polar_wreq      = "NORMAL" ;
  parameter polar_rreq      = "NORMAL" ;
  parameter polar_clock     = "NORMAL" ;
  parameter polar_clockx2   = "NORMAL" ;
  parameter polar_clr       = "NORMAL" ;
  parameter polar_threshlevel= "NORMAL" ;
  parameter polar_q         = "NORMAL" ;
  parameter polar_full      = "NORMAL" ;
  parameter polar_empty     = "NORMAL" ;
  parameter polar_threshold = "NORMAL" ;

input [lpm_width-1:0] data;
input wreq;
input rreq;
input clock;
input clockx2;
input clr;
input [lpm_widthad-1:0] threshlevel;
output empty;
output full;
output [lpm_width-1:0] q;
output threshold;


// internal reg
reg [lpm_width-1:0] mem_data [lpm_numwords-1:0];
reg [lpm_width-1:0] tmp_q;
reg [lpm_width-1:0] pdata;
reg pwreq;
reg prreq;
reg pclock;
reg pclockx2;
reg pclr;
reg [lpm_widthad-1:0] pthreshlevel;
reg [lpm_width-1:0] ZEROS;
reg [lpm_width-1:0] clocked_data;
reg [lpm_widthad-1:0] count_id;
reg [lpm_widthad-1:0] write_id;
reg [lpm_widthad-1:0] read_id;
reg write_read;
reg write_en;
reg read_en;
reg empty_flag;
reg full_flag;
reg thresh_flag;
integer i;

pullup P1 (threshlevel[0]);
// pragma translate_off
initial
begin
  // check for number of words out of bound
   if(lpm_numwords > (1 << lpm_widthad))
         $display("Error! Too many words defined.");
 
   for (i=0; i < lpm_width; i=i+1)
          ZEROS[i] = 1'b0;

   for (i=0; i < lpm_widthad; i=i+1)
      begin
          count_id[i] = 1'b0;
          write_id[i] = 1'b0;
          read_id[i] = 1'b0;
      end

   for(i = 0; i < lpm_numwords; i=i+1)
         mem_data[i] = ZEROS;

   empty_flag = 1;
   full_flag = 0;
   write_read = 0;
   write_en = 0;
   read_en = 0;
   thresh_flag = 0;
end

  always @(data )
    pdata    <= #1 (polar_data == "INVERT")?~data:data;

  always @(wreq)
      pwreq <= #1 (polar_wreq == "INVERT")?~wreq:wreq;
 
  always @(rreq)
      prreq <= #1 (polar_rreq == "INVERT")?~rreq:rreq;
 
  always @(clock)
      pclock <= #1 (polar_clock == "INVERT")?~clock:clock;
 
  always @(clockx2)
      pclockx2 <= #1 (polar_clockx2 == "INVERT")?~clockx2:clockx2;
    
  always @(clr)
      pclr <= #1 (polar_clr == "INVERT")?~clr:clr;
    
  always @(threshlevel)
      pthreshlevel <= #1 (polar_threshlevel == "INVERT")?~threshlevel:threshlevel;
    

  always @(pclr)
     begin 
         for (i=0; i < lpm_width; i=i+1)
               tmp_q[i]  = 1'b0;

         full_flag = 0;
         read_en  = 0;
         read_id  = 0;
         write_id  = 0;
         write_en  = 0;
         count_id  = 0;
         empty_flag  = 1;
         thresh_flag = 0;
     end 

  always @( posedge pclock)
     begin 
         write_en = 0;
         read_en = 0;
         clocked_data = pdata;

         if (pwreq && !full )
              write_en = 1;

         if (prreq && !empty)
              read_en = 1;

         if ( (pwreq && !full ) ^ (prreq && !empty)) 
              write_read = 0;
         else
              write_read = 1;
     end 

  always @( posedge pclockx2)
     begin
         if ( write_en && !pclock )
             begin
                 empty_flag = 0;
                 mem_data[write_id] = clocked_data;

                 if (!full_flag)
                     begin
                          if (write_id == lpm_numwords - 1)
                              write_id = 0;
                          else
                              write_id = write_id + 1;
                     end

                 if (!write_read)
                    begin
                        if (count_id == lpm_numwords - 1)
                            full_flag = 1;
                        else if (count_id == pthreshlevel - 1)
                            begin
                               thresh_flag = 1;
                               count_id = count_id + 1;
                           end
                        else
                            count_id = count_id + 1;
                     end
             end
         else if ( read_en && pclock)
             begin
                 full_flag = 0;
                 tmp_q = mem_data[read_id];

                 if (!empty_flag)
                     begin
                        if (read_id == lpm_numwords - 1 )
                             read_id = 0;
                        else
                             read_id = read_id + 1;
                     end

                 if (!write_read)
                    begin
                      if (count_id < 1)
                          empty_flag = 1;
                      else if (count_id == pthreshlevel - 1)
                          begin
                              thresh_flag = 0;
                              count_id = count_id - 1;
                          end
                      else 
                           count_id = count_id - 1;
                    end
             end
     end

   assign q = (polar_q === "INVERT")?~tmp_q:tmp_q;
   assign full = (polar_full === "INVERT")?~full_flag:full_flag;
   assign empty = (polar_empty === "INVERT")?~empty_flag:empty_flag;
   assign threshold = (polar_threshold === "INVERT")?~thresh_flag:thresh_flag;

  //pragma translate_on
endmodule // cs_fifo_d
`ifdef SYNTH
`else
`endcelldefine
`endif
